/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.file_server;

import ibm.nways.nhm.file_server.RemoteDirectoryHandle;
import ibm.nways.nhm.file_server.RemoteDirectoryHandleImpl;
import ibm.nways.nhm.file_server.RemoteFileServer;
import ibm.nways.nhm.file_server.RemoteInputHandle;
import ibm.nways.nhm.file_server.RemoteInputHandleImpl;
import ibm.nways.nhm.file_server.RemoteOutputHandle;
import ibm.nways.nhm.file_server.RemoteOutputHandleImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class RemoteFileServerImpl
extends UnicastRemoteObject
implements RemoteFileServer {
    private String rootPath;

    public RemoteFileServerImpl() throws RemoteException {
    }

    public RemoteFileServerImpl(String string) throws RemoteException {
        if (string != null) {
            this.rootPath = string;
        }
    }

    public boolean checkPathName(String string) {
        if (string.charAt(0) == File.separatorChar) {
            return false;
        }
        if (string.charAt(1) == ':' && string.charAt(2) == File.separatorChar) {
            return false;
        }
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '.' && string.charAt(n + 1) == '.') {
                return false;
            }
            ++n;
        }
        return true;
    }

    public RemoteInputHandle getInStream(String string) throws RemoteException {
        Object object;
        FileInputStream fileInputStream = null;
        System.err.println("RFSI::getInStream( \"" + string + "\" )");
        if (!this.checkPathName(string)) {
            RemoteException remoteException = new RemoteException("Invalid pathname '" + string + "'.");
            throw remoteException;
        }
        try {
            object = this.rootPath != null ? String.valueOf(this.rootPath) + File.separator + string : string;
            fileInputStream = new FileInputStream((String)object);
        }
        catch (FileNotFoundException fileNotFoundException) {
            RemoteException remoteException = new RemoteException("File does not exist: " + fileNotFoundException.getMessage());
            throw remoteException;
        }
        catch (IOException iOException) {
            RemoteException remoteException = new RemoteException("Error opening file: " + iOException.getMessage());
            throw remoteException;
        }
        object = new RemoteInputHandleImpl(fileInputStream);
        return object;
    }

    public RemoteOutputHandle getOutStream(String string, boolean bl) throws RemoteException {
        Object object;
        FileOutputStream fileOutputStream = null;
        System.err.println("RFSI::getOutStream( \"" + string + "\" )");
        if (!this.checkPathName(string)) {
            RemoteException remoteException = new RemoteException("Invalid pathname '" + string + "'.");
            throw remoteException;
        }
        try {
            object = this.rootPath != null ? String.valueOf(this.rootPath) + File.separator + string : string;
            fileOutputStream = new FileOutputStream((String)object, bl);
        }
        catch (IOException iOException) {
            RemoteException remoteException = new RemoteException("Error opening file: " + iOException.getMessage());
            throw remoteException;
        }
        object = new RemoteOutputHandleImpl(fileOutputStream);
        return object;
    }

    public RemoteDirectoryHandle getDirectory(String string) throws RemoteException {
        Object object;
        File file = null;
        System.err.println("RFSI::getDirectory( \"" + string + "\" )");
        if (!this.checkPathName(string)) {
            RemoteException remoteException = new RemoteException("Invalid pathname '" + string + "'.");
            throw remoteException;
        }
        try {
            object = this.rootPath != null ? String.valueOf(this.rootPath) + File.separator + string : string;
            file = new File((String)object);
        }
        catch (NullPointerException nullPointerException) {
            RemoteException remoteException = new RemoteException("Error opening file: " + ((Throwable)nullPointerException).getMessage());
            throw remoteException;
        }
        if (!file.exists()) {
            object = new RemoteException("Directory " + string + "does not exist.");
            throw object;
        }
        if (!file.isDirectory()) {
            object = new RemoteException(String.valueOf(string) + "is a file, not a directory.");
            throw object;
        }
        object = new RemoteDirectoryHandleImpl(file);
        return object;
    }

    public static void main(String[] stringArray) {
        System.setSecurityManager(new RMISecurityManager());
        try {
            System.err.println("RFSI::main: creating RFSI.");
            RemoteFileServerImpl remoteFileServerImpl = new RemoteFileServerImpl();
            String string = "RFSI";
            System.err.println("RFSI::main: binding to name: " + string);
            Naming.rebind(string, remoteFileServerImpl);
            return;
        }
        catch (Exception exception) {
            System.err.println("Exception creating server: " + exception + "\n");
            exception.printStackTrace(System.err);
            return;
        }
    }
}

